<?php
if(!function_exists('bixol_configs')){
    function bixol_configs($value){
         
        $configs = [
            'theme_colors' => [
                'primary'   => [
                    'title' => esc_html__('Primary', 'bixol').' ('.bixol_get_opt('primary_color', '#22d3ee').')', 
                    'value' => bixol_get_opt('primary_color', '#22d3ee')
                ],
                'secondary'   => [
                    'title' => esc_html__('Secondary', 'bixol').' ('.bixol_get_opt('secondary_color', '#0431b8').')', 
                    'value' => bixol_get_opt('secondary_color', '#0431b8')
                ],
                'third'   => [
                    'title' => esc_html__('Third', 'bixol').' ('.bixol_get_opt('third_color', '#4a74f0').')', 
                    'value' => bixol_get_opt('third_color', '#4a74f0')
                ],
                'four'   => [
                    'title' => esc_html__('Four', 'bixol').' ('.bixol_get_opt('four_color', '#2593d5').')', 
                    'value' => bixol_get_opt('four_color', '#2593d5')
                ],
                'fifth'   => [
                    'title' => esc_html__('Fifth', 'bixol').' ('.bixol_get_opt('fifth_color', '#8cd102').')', 
                    'value' => bixol_get_opt('fifth_color', '#8cd102')
                ],
                'dark'   => [
                    'title' => esc_html__('Dark', 'bixol').' ('.bixol_get_opt('dark_color', '#082680').')', 
                    'value' => bixol_get_opt('dark_color', '#082680')
                ]
            ],
            'link' => [
                'color' => bixol_get_opt('link_color', ['regular' => '#22d3ee'])['regular'],
                'color-hover'   => bixol_get_opt('link_color', ['hover' => '#0431b8'])['hover'],
                'color-active'  => bixol_get_opt('link_color', ['active' => '#0431b8'])['active'],
            ],
               
        ];
        return $configs[$value];
    }
}
if(!function_exists('bixol_inline_styles')) {
    function bixol_inline_styles() {  
        
        $theme_colors      = bixol_configs('theme_colors');
        $link_color        = bixol_configs('link');
        ob_start();
        echo ':root{';
            
            foreach ($theme_colors as $color => $value) {
                printf('--%1$s-color: %2$s;', str_replace('#', '',$color),  $value['value']);
            }
            foreach ($theme_colors as $color => $value) {
                printf('--%1$s-color-rgb: %2$s;', str_replace('#', '',$color),  bixol_hex_rgb($value['value']));
            }
            foreach ($link_color as $color => $value) {
                printf('--link-%1$s: %2$s;', $color, $value);
            }
        echo '}';

        return ob_get_clean();
         
    }
}
 